/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.EjbInvocation;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EjbFutureTask;
import com.sun.ejb.containers.InvocationHandlerUtil;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.util.Utility;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class EjbAsyncTask<V>
implements Callable<V> {
    private EjbInvocation inv;
    private EjbFutureTask ejbFutureTask;
    private SecurityContext callerSecurityContext;

    public void initialize(EjbInvocation inv) {
        this.inv = inv;
        this.ejbFutureTask = inv.getEjbFutureTask();
        this.callerSecurityContext = SecurityContext.getCurrent();
    }

    public long getInvId() {
        return this.inv.getInvId();
    }

    FutureTask getFutureTask() {
        return this.ejbFutureTask;
    }

    EjbInvocation getEjbInvocation() {
        return this.inv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V call() throws Exception {
        Object returnValue = null;
        BaseContainer container = (BaseContainer)this.inv.container;
        ClassLoader prevCL = Thread.currentThread().getContextClassLoader();
        try {
            Utility.setContextClassLoader((ClassLoader)container.getClassLoader());
            SecurityContext.setCurrent((SecurityContext)this.callerSecurityContext);
            container.preInvoke(this.inv);
            returnValue = container.intercept(this.inv);
            if (returnValue instanceof Future) {
                returnValue = ((Future)returnValue).get();
            }
        }
        catch (InvocationTargetException ite) {
            this.inv.exceptionFromBeanMethod = this.inv.exception = ite.getCause();
        }
        catch (Throwable t) {
            this.inv.exception = t;
        }
        finally {
            block28: {
                try {
                    container.postInvoke(this.inv, this.inv.getDoTxProcessingInPostInvoke());
                    if (this.inv.exception == null) break block28;
                    if (this.inv.isLocal) {
                        InvocationHandlerUtil.throwLocalException(this.inv.exception, this.inv.method.getExceptionTypes());
                    } else {
                        InvocationHandlerUtil.throwRemoteException(this.inv.exception, this.inv.method.getExceptionTypes());
                    }
                }
                catch (Throwable th) {
                    ExecutionException ee = new ExecutionException(th);
                    this.ejbFutureTask.setResultException(ee);
                    throw ee;
                }
                finally {
                    SecurityContext.setCurrent(null);
                    Utility.setContextClassLoader((ClassLoader)prevCL);
                }
            }
        }
        this.ejbFutureTask.setResultValue(returnValue);
        return (V)returnValue;
    }
}

