/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility.generator.io;

import com.sun.jdo.spi.persistence.utility.generator.JavaClassWriter;
import com.sun.jdo.spi.persistence.utility.generator.JavaFileWriter;
import com.sun.jdo.spi.persistence.utility.generator.io.FormattedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;

public class IOJavaFileWriter
implements JavaFileWriter {
    private static final ResourceBundle _messages = I18NHelper.loadBundle(IOJavaFileWriter.class);
    private File _file;
    private String _packageBlock;
    private List _importStatements = new ArrayList();
    private List _classes = new ArrayList();

    public IOJavaFileWriter(File file) {
        this._file = file;
    }

    protected static final ResourceBundle getMessages() {
        return _messages;
    }

    @Override
    public void setPackage(String packageName, String[] comments) {
        FormattedWriter writerHelper = new FormattedWriter();
        writerHelper.writeComments(comments);
        if (packageName != null && packageName.length() > 0) {
            writerHelper.writeln("package " + packageName + ';');
            writerHelper.writeln();
        }
        this._packageBlock = writerHelper.toString();
    }

    @Override
    public void addImport(String importName, String[] comments) {
        FormattedWriter writerHelper = new FormattedWriter();
        writerHelper.writeComments(comments);
        if (importName != null && importName.length() > 0) {
            writerHelper.writeln("import " + importName + ';');
        }
        this._importStatements.add(writerHelper.toString());
    }

    @Override
    public void addClass(JavaClassWriter classWriter) {
        if (classWriter != null) {
            this._classes.add(classWriter);
        }
    }

    @Override
    public void save() throws IOException {
        if (this._file != null) {
            File directory = this._file.getParentFile();
            if (directory != null && !directory.exists() && !directory.mkdirs()) {
                throw new IOException(I18NHelper.getMessage(IOJavaFileWriter.getMessages(), "utility.unable_create_destination_directory", directory.getPath()));
            }
            try (FileWriter fileWriter = new FileWriter(this._file);){
                fileWriter.write(this.toString());
            }
        }
    }

    public String toString() {
        FormattedWriter writerHelper = new FormattedWriter();
        writerHelper.writeln();
        if (this._packageBlock != null) {
            writerHelper.write(this._packageBlock);
        }
        writerHelper.writeList(this._importStatements);
        writerHelper.writeList(this._classes);
        return writerHelper.toString();
    }
}

